<?php
include "admin/conn.php";
// Start session
session_start();
// Check if the user is already logged in
if (!empty($_SESSION["id"])) {
    header("Location: login.php");
    exit(); // Make sure to exit after redirecting
}

if (isset($_POST["submit"])) {
    $usernameemail = $_POST["usernameemail"];
    $password = $_POST["password"];

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("SELECT id, username, email, password FROM tb_user WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $usernameemail, $usernameemail);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $username, $email, $hashedPassword);
        $stmt->fetch();

        // Verify the password using password_verify
        if (password_verify($password, $hashedPassword)) {
            $_SESSION["id"] = $id;
            $_SESSION["username"] = $username;
            $_SESSION["email"] = $email;
            
            $stmt->close();
            
            header("Location: members.php");
            exit(); // Make sure to exit after redirecting
        } else {
            echo "<script>alert('Wrong Password');</script>";
        }
    } else {
        echo "<script>alert('User Not Registered');</script>";
    }

    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Naughtyclicks Login Page">
    <title>Login - Naughtyclicks</title>
    <link rel="icon" type="image/png" href="images/favicon.png">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background: #000;
            color: #fff;
            font-family: 'Arial', sans-serif;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0;
        }

        .login-container {
            background: #000;
            border-radius: 15px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            text-align: center;
        }

        .login-container h1 {
            margin-bottom: 20px;
            color: #333;
            font-size: 28px;
            font-weight: bold;
        }

        .login-container h3 {
            margin-bottom: 20px;
            color: #000;
            font-size: 22px;
            font-weight: bold;
        }

        .form-input {
            position: relative;
            margin-bottom: 20px;
        }

        .form-input {
            position: relative;
            margin-bottom: 20px;
        }

        .form-input input {
            width: 100%;
            padding: 10px 0;
            border: none;
            border-bottom: 2px solid rgba(255, 255, 255, .12);
            background: transparent;
            color: #fff;
            font-size: 16px;
        }

        .form-input input:focus {
            border-bottom: 2px solid #F26E65;
            outline: none;
        }

        .form-input label {
            position: absolute;
            top: 50%;
            left: 0;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, .5);
            font-size: 16px;
            pointer-events: none;
            transition: all 0.3s ease;
        }

        .form-input input:focus + label,
        .form-input input:not(:placeholder-shown) + label {
            top: -10px;
            font-size: 12px;
            color: #F5A72A;
        }

        .form-input-checkbox {
            text-align: left;
            margin-bottom: 20px;
        }

        .form-input-checkbox label {
            margin-left: 5px;
            color: #555;
        }

        .main-btn {
            background-color: #F26E65;
            border: none;
            color: #fff;
            padding: 12px 20px;
            font-size: 16px;
            font-weight: 500;
            border-radius: 15px;
            cursor: pointer;
            transition: background 0.3s, transform 0.2s;
        }

        .main-btn:hover {
            background-color:rgb(211, 94, 86);

            /* transform: scale(1.05); */
        }

        .login-container p {
    margin-top: 10px;
    font-size: 14px;
    color: #fff;
    margin-bottom: 28px;
}

        .login-container p a {
            color:rgb(234, 65, 23);
            text-decoration: none;
        }

        .login-container p a:hover {
            text-decoration: underline;
        }

        .additional-content {
            margin-top: 30px;
            font-size: 14px;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="login-container">
    <div class="logo" style="text-align: center;">
        <a href="home.php">
            <img src="images/logo.png" class="img-fluid" alt="logo" style="max-width: 80%; margin: 0 auto;">
        </a>
    </div>
        <p>Connect, chat, and explore a world of possibilities.</p>
        <form method="POST" onsubmit="return validateForm();">
            <div class="form-input">
                <input type="text" id="usernameemail" name="usernameemail" placeholder="Email Address/Username *" required>
                <label for="usernameemail"></label>
            </div>
            <div class="form-input">
                <input type="password" id="password" name="password" placeholder="Password *" required>
            </div>
            <div class="form-input-checkbox">
                <input type="checkbox" id="rememberme" name="rememberme">
                <label for="rememberme">Remember me</label>
            </div>
            <button class="main-btn" name="submit" type="submit">Log In</button>
        </form>
        <p>Not a member yet? <a href="home.php">Let's Go</a> and start your journey!</p>
        <div class="additional-content">
            <p>Discover new friends, share your stories, and make unforgettable memories. Join us today!</p>
        </div>
    </div>

    <script>
        function validateForm() {
            const usernameemail = document.getElementById('usernameemail').value;
            const password = document.getElementById('password').value;
            if (usernameemail.trim() === '' || password.trim() === '') {
                alert('Please fill out all fields.');
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
